﻿init -1 python hide:

    config.developer = True
    config.screen_width = 1024
    config.screen_height = 576
    config.window_title = u"Portrait System Demo"
    config.name = "talktest"
    config.version = "1.3"

    #########################################
    # Themes
    
    theme.threeD(
        widget = "#003c78",
        widget_hover = "#0050a0",
        widget_text = "#c8ffff",
        widget_selected = "#ffffc8",
        disabled = "#404040",
        disabled_text = "#c8c8c8",
        label = "#ffffff",
        frame = "#6496c8",
        mm_root = "graphics/bg/title.png",
        gm_root = "#dcebff",
        rounded_window = False,
        )
            
    #########################################
python early:
    config.save_directory = None

init -1 python hide:
    #########################################
    ## Default values of Preferences.

    renpy.music.register_channel("music", mixer="music", loop=True, tight=True, file_prefix='audio/bgm/')
    renpy.music.register_channel("bgs", mixer="music", loop=True, tight=True, file_prefix='audio/bgs/')
    renpy.music.register_channel("sound", mixer="sfx", loop=False, file_prefix='audio/se/')
    renpy.music.register_channel("text", mixer="voice", loop=True, file_prefix='audio/se/')

    ## Should we start in fullscreen mode?
    config.default_fullscreen = False
    ## The default text speed in characters per second. 0 is infinite.
    config.default_text_cps = 40
    ## The default auto-forward time setting.
    config.default_afm_time = 10

    #########################################
    ## More customizations can go here.

    # Text window
    config.window_show_transition = dissolve
    config.window_hide_transition = dissolve
    # ADV <-> NVL
    config.adv_nvl_transition = dissolve
    config.nvl_adv_transition = dissolve
    
##############################################################################
    
init:  
    style default:
        font                    "graphics/ume-ugo4-256.ttf"
        size                    24
        line_spacing            2
        color                   "#eee"
        
    style say_window:
        xpadding                172
        ypadding                16
        ysize                   160
        box_spacing             0
        
    style say_dialogue:
        outlines                [(1, "#151613", 1, 1), (1, "#151613", 0, 0)]
        color                   "#eee"
        textalign               0.0
        
    style say_label:
        outlines                [(1, "#151613", 1, 1), (1, "#151613", 0, 0)]
        bold                    False
        color                   "#ffffc8"
    style say_vbox:
        spacing                 0
        
    style nvl_window:
        xpadding                172
        ypadding                32
        box_spacing             18
        
    image continimg:
        "graphics/arrow.png"
        alpha 0.0
        linear 0.8 alpha 1.0
        pause 1
        linear 0.8 alpha 0.0
        repeat
            
##############################################################################

init:
    transform left:
        pos(0.33, 0.5)
        anchor(0.5, 0.5)
    transform center:
        pos(0.5, 0.5)
        anchor(0.5, 0.5)
    transform right:
        pos(0.66, 0.5)
        anchor(0.5, 0.5)
        
    transform char_fade:
        on show:
            alpha 0.0
            linear 0.2 alpha 1.0
        on hide:
            linear 0.2 alpha 0.0    
        on replace:
            linear 0.2 alpha 1.0
        on replaced:
            linear 0.2 alpha 0.0 
          
##############################################################################
           